/* -------------------------------------------------- */
/* OPERATION : PewPew!                                */
/* By: DW / Dark Systems BBS                          */
/* www.DSBBS.ca                                       */
/*                                                    */
/* January 2026                                       */
/* Release 1.0 (68040 version)                        */
/*                                                    */
/* This is the (mostly) FULLY COMMENTED C source code */
/*                                                    */
/* Started out as a hobby project to see if I still   */
/* remembered how to create a parallax scrolling star */
/* field like it was 1989. :)                         */
/* Somehow became addictive and turned into the       */
/* little shooter game it is today.                   */
/*                                                    */
/* I hope this commented source helps someone         */
/* understand how the various parts of the game work  */
/* and might encourage you to write and share you own */
/* vintage game or application!                       */
/*                         Keep those machines alive! */
/*                                                    */
/* I'm not a professional programmer by any means,    */
/* just a Firefighter with a nostalgic love for this  */
/* stuff, so please feel free to improve and fix my   */
/* chicken-scratch code and routines! :)              */
/*                                                    */
/* 68030 compatible version coming soon! (I hope) :)  */
/*                                                    */
/* Code ................. Me!                         */
/* MOD player libraries . PlayerPRO by Antoine Rosset */
/* In game music MOD .... Stardust Memories by Jester */
/*                                                    */
/* Questions, comments, requests, anything...         */
/*                        eMail: aaron@jaggedpath.com */
/*                                                    */
/* IDE info:                                          */
/*           Written in CodeWarrior PRO 4             */
/*                                                    */
/* -------------------------------------------------- */


#include <MacTypes.h>
#include <QuickDraw.h>
#include <Windows.h>
#include <Events.h>
#include <Resources.h>
#include <QDOffscreen.h>
#include <Sound.h>
#include <stdlib.h>
#include <Processes.h>
#include <Files.h>
#include "RDriver.h" /* Part of PlayerPRO's MOD music playback */

/* --- Constants & Boundaries --- */
#define WIN_WIDTH 490  /* Total width of the game window */
#define WIN_HEIGHT 280 /* Total height of the game window */
#define PLAY_AREA_TOP    40   /* HUD at the top Health, score, etc */
#define PLAY_AREA_BOTTOM 240  /* Text scroller area at the bottom */

#define NUM_STARS 60 /* Total number of parallax stars */
#define MAX_LASERS 5  /* Number of shots player can shoot at once */
#define MAX_PARTICLES 64  /* MAX pixel particles on screen during explosions */
#define MAX_ASTEROIDS 5 /* MAX number of asteroids on screen */
#define MAX_BOSS_SHOTS 8  /* MAX number of missiles the boss can have on screen */
#define MAX_TRAIL 4 /* MAX length a missile trail can be */
#define NUM_MESSAGES 7 /* Total number of scrolling messages along the bottom */
#define MAX_BOMBS 5 /* MAX number of plasma bombs player can have in inventory */

/* As the game progresses the STATE changes and is checked to trigger the correct parts of the code */
#define STATE_START 0 /* Startup state, main menu */
#define STATE_PLAYING 1 /* Let's play the game! */
#define STATE_BOSS 2 /* Oh no! A boss fight is on! */
#define STATE_GAMEOVER 3 /* Game over, sorry for your luck! ;) */
#define STATE_ABOUT 4 /* You're in the 'about' screen */

#define BOSS_BAR_LEFT   225 /* How many pixels in from the left (X) to start the Boss health bar */
#define BOSS_BAR_TOP    10 /* 10 pixels down from the top (Y) of the window */
#define BOSS_BAR_WIDTH  100 /* 100 pixels long */

/* --- Sound FX Constants --- */
#define kLaserSndID 128 
#define kExplodeSndID 129
#define kEnergyGetSndID 130   /* Each sound FX and their corresponding resource file ID */ 
#define kEnergyBlastSndID 131  
#define kUFOSndID 132 
#define kBombGetSndID   133
#define kBombBlastSndID 134      

#define kMaxChannels 4 /* Total number of sound channels to use for the sound FX. Default is 4 SFX playing at a time */

/* --- Fixed Point Macros --- */
#define INT_TO_FIXED(x) ((Fixed)(x) << 16) /* Converts a standard Integer into a Fixed-Point number. */
#define FIXED_TO_INT(x) (*((short *)&(x))) /* Ultra-fast way of pulling the whole number back out so QuickDraw can draw it on the screen */
#define FL_TO_FIXED(x)  ((Fixed)((x) * 65536L)) /* allows the use of Floating Point constants (decimals) */

/* --- Structures --- */
typedef struct {
	short x, y, speed; /* Pixel coordinates for the background star field; standard 'short' is used for their speed */
}
Star;

typedef struct {
	Fixed x; /* Fixed-point horizontal position for smooth scrolling bottom text*/
	short baseY, currentY; /* The vertical 'anchor' point and the actual vertical pixel position, calculated using sine, of the angle of the text*/
	short angle; /* The current phase of the sine wave; incremented to create the waving motion */
	short msgIndex; /* Pointer to the current string being displayed from the gEncouragement array */
}
Ticker;

typedef struct {
	short x, y, speed; /* Pixel screen coordinates and standard 'short' used for the drift, and the speed of the drift for each asteroid (in pixels) */
	Boolean active; /* If true, the asteroid is a threat and needs to be Pew Pew'd!  If false, it can be respawned on the right */
}
Asteroid;

typedef struct {
	short x, y; /* Pixel coordinates for the player's pewer laser. 'Short' is used for fast linear travel */
	Boolean active; /* True if the laser is currently in flight and capable of hitting an enemy */
}
Laser;

typedef struct { 
    	Fixed x, y, vx, vy; /* High-precision 16.16 fixed-point coordinates and velocity for sub-pixel movement */
    	short trailX[MAX_TRAIL], trailY[MAX_TRAIL]; /* Buffer of previous screen-space positions to render motion trails */
    	Boolean active; /* Flag for the object pool; true if projectile is currently in flight... WATCH OUT! */
	}
	Projectile; 

	typedef struct { Fixed x, y, vx, vy; /* Particle position and velocity. Fixed-point allows for 'floaty' or 'explosive' expansion */
		short life; /* Time-To-Live (TTL). Determines how long the explosion 'spark' remains visible */
		Boolean active; /* When false, the particle is 'dead' and can be reused by the next explosion trigger */
	}
	Particle;
	
	typedef struct {
		short x, y; /* Screen coordinates in pixels; standard 'short' used for simple speed and drift across the play area */
		Boolean active; /* If true, the Energy Pod is visible on screen and available for pickup. BLAST EM!*/
	}
	Energy;
	
	typedef struct {
		short x, y; /* Screen coordinates in pixels; standard 'short' used for simple speed and drift across the play area */
		Boolean active; /* Pickup status; true if the plasma bomb icon is currently floating across the play area */
	}
	PlasmaItem;
	
	typedef struct {
		Fixed x, y; /* Fixed-point position for smooth, sub-pixel boss maneuvering */
		short hp; /* Boss hit points determines how many laser strikes are needed to defeat it */
		short pulse; /* Sine-wave index used to create the 'throbbing' or 'pulsing' size change effect */
		Boolean active; /* True if the boss encounter is currently active */
	}
	JellyBoss; /* Note: This was written when there was only 1 boss, the Jelly Boss.  Now there are multiple, but the Jelly name stuck... */
	
	typedef struct {
		Fixed x, y; /* Fixed-point coordinates for smooth, fluid interception and hovering */
		short targetX; /* The horizontal pixel position the UFO is trying to reach or maintain to harass  the player and not just exit the screen. What a jerk!*/
		short bobDir; /* Vertical movement state used to create a 'bobbing' or 'wavering' flight pattern.  Great... drunk alien pilots...  */
		short fireTimer; /* Frame countdown between shots. regulates the UFO's firing rate is 1 shot at a time */
		Boolean active; /* If true, the UFO is active and currently hunting the player. Watch out! He's got his probe! :D */
	}
	UFO;
	
	
	/* --- Globals --- */
	Star starfield[NUM_STARS];
	Ticker gTicker;
	Asteroid gAsteroids[MAX_ASTEROIDS];
	Laser gLasers[MAX_LASERS];
	Projectile gBossShots[MAX_BOSS_SHOTS];
	Projectile gUFOShot; 
	Particle gParticles[MAX_PARTICLES];
	Energy gEnergyItem;
	PlasmaItem gPlasmaItem;
	JellyBoss gBoss;
	UFO gUFO;
	WindowPtr gWindow = NULL;
	GWorldPtr gOffscreen = NULL;
	Boolean gMusicEnabled = true;

/* --- Sound Globals --- */

/* gSoundPool is an array of pointers to the Sound Manager channels defined above (kMaxChannels 4). */
/* Allows for 4 SFX to be played at once, utilizing each channel in a round-robin cycle. 5th SFX would cut off 1st, etc */
SndChannelPtr gSoundPool[kMaxChannels];

/* The sound FX */
Handle gLaserSnd = NULL, gExplodeSnd = NULL, gEnergyGetSnd = NULL, gEnergyBlastSnd = NULL, gUFOSnd = NULL, gBombGetSnd = NULL, gBombBlastSnd = NULL;

short gNextChannel = 0; /* The next available sound channel to use, starting at 0, 1, 2, 3 */
Boolean gSoundEnabled = true; /* Works with the MUTE button on the main menu */

long gScore = 0; /* Holds that players score. 2,147,483,647pts MAX... you up for it? lol */
long gHighScore = 0; /* Holds the highest score achieved */       
long gNextBossScore = 500; /* The score increment required to reach the next boss character */

Boolean gNewRecord = false; /* Triggers the celebration if a new high score is achieved (YAY!) */

short gHealth = 100; /* Players energy life bar*/
short gBombCount = 0; /* How many plasma bombs the player has in inventory */
short gShakeTimer = 0, gInvincTimer = 0, gBossFireTimer = 0, gWarningTimer = 0; /* Screen shake timers for the offset calculations */
short gBossHitTimer = 0; /* Jiggle offset for the boss and health bar when boss takes a hit */
short gGameState = STATE_START; /* Track what state the same is in for the correct code is ran */
Boolean gFlashRequest = false; /* Inverts the screen on impact, etc when true */
unsigned long gNextFrameTick = 0, gNextEnergyTick = 0; /* Trying to regulate game speed on various CPUs */
Rect gPlayAgainBtn, gStartBtn, gAboutBtn, gQuitBtn, gMuteRect, gMusicRect; /* Rectangles for the various menu buttons */


/* --- Bitmaps --- */
/* NOTE: All sprite bitmaps drawn with SquirrelEDIT 1.9.1 */
/* Shameless self promotion! lol :) */

/* Object, enemy, item and menu soundFX/music sprites are all 16x16 pixels */
/* Boss sprites are 32x32 pixels */

/* Player ship sprite */
static unsigned short shipBits[] = {
 0x0000,
 0x3FC0,
 0x643E,
 0xF138,
 0xE0A4,
 0x6402,
 0x3FFE,
 0x2A59,
 0x3559,
 0x3FFE,
 0x6802,
 0xF224,
 0xE4B8,
 0x683E,
 0x3FC0,
 0x0000
};

/* Asteroid sprite */
static unsigned short asteroidBits[] = {
 0x0000, 
 0x0770, 
 0x0EF8, 
 0x1EF8, 
 0x3CE8, 
 0x7B70, 
 0x7F80, 
 0x7E88, 
 0x7F98, 
 0x7B10, 
 0x7C00, 
 0x3C20, 
 0x1B00, 
 0x0F08, 
 0x0610, 
 0x0000
};

/* Energy power up sprite */
static unsigned short energyBits[] = {
 0xFFFC,
 0x8004,
 0x8604,
 0x8604,
 0x8604,
 0x8F14,
 0x8F14,
 0xFFFF,
 0x8F14,
 0x8F14,
 0x8604,
 0x8604,
 0x8604,
 0x8004,
 0xFFFC,
 0x0000
};

/* Plasma Bomb sprite */
static unsigned short bombBits[] = {
  0x03E0,
  0x1FF8,
  0x2004,
  0x47F2,
  0x47E2,
  0x4FC2,
  0x4FFA,
  0x5FFA,
  0x5FF2,
  0x43E2,
  0x47C2,
  0x4782,
  0x4F02,
  0x4C02,
  0x2004,
  0x1FF8
};


/* Boss Sprites */

/* DeathStar 2 boss sprite */
static unsigned short boss1Bits[] = {
  0x0000, 0x0000,
  0x0000, 0x0000,
  0x0007, 0xF000,
  0x003F, 0xFE00,
  0x007F, 0xF000,
  0x01FF, 0xFF00,
  0x03E3, 0xFD80,
  0x07DD, 0xED00,
  0x0794, 0xFF80,
  0x0FA2, 0xFD00,
  0x1FB6, 0xF2F0,
  0x1FDD, 0xFFC0,
  0x1FE3, 0xFB00,
  0x3FFF, 0xFFC0,
  0x3FFF, 0xFC00,
  0x3FFF, 0xFFF0,
  0x0000, 0x0000,
  0x3FFF, 0xFFB8,
  0x3FFF, 0x5FF8,
  0x3EFF, 0xFC00,
  0x1BFD, 0xFD70,
  0x1FFB, 0xC000,
  0x1FFD, 0xEC04,
  0x0FFF, 0xF008,
  0x07FF, 0xF880,
  0x07BD, 0xF7F0,
  0x03FF, 0xF920,
  0x01FE, 0x2840,
  0x007F, 0xFF00,
  0x003F, 0xEE00,
  0x0007, 0xF000,
  0x0000, 0x0000
};

/* Alien UFO boss sprite */
static unsigned short boss2Bits[] = {
  0x0000, 0x0000,
  0x0003, 0xC000,
  0x000C, 0x3000,
  0x0010, 0xC800,
  0x0020, 0x2400,
  0x0020, 0x1400,
  0x0043, 0xC200,
  0x0047, 0xE200,
  0x004B, 0xD200,
  0x0089, 0x9100,
  0x0089, 0x9100,
  0x009D, 0xB900,
  0x009F, 0xF900,
  0x010F, 0xF080,
  0x0107, 0xE080,
  0x0106, 0x6080,
  0x0D03, 0xC0B0,
  0x3D01, 0x80BC,
  0x42C1, 0x8342,
  0x8123, 0xC481,
  0x8897, 0xE911,
  0x948F, 0xF129,
  0x8860, 0x0611,
  0x411F, 0xF842,
  0x2200, 0x0224,
  0x188A, 0xA918,
  0x0615, 0x5060,
  0x07C0, 0x03E0,
  0x0C3F, 0xFC30,
  0x0C01, 0x8030,
  0x1C01, 0x8038,
  0x3E03, 0xC07C
};

/* Angry Jelly boss sprite */
static unsigned short boss3Bits[] = {
  0x0007, 0xE000,
  0x0018, 0x9800,
  0x0065, 0x2600,
  0x01B1, 0x0D80,
  0x0208, 0x9040,
  0x0565, 0x26A0,
  0x0A79, 0x1E50,
  0x156C, 0x36A8,
  0x1472, 0x4E28,
  0x2936, 0x6C94,
  0x281E, 0x7814,
  0x5080, 0x010A,
  0x413F, 0xFC82,
  0x9340, 0x0249,
  0x9100, 0x108D,
  0xC39D, 0xEB1E,
  0xBC62, 0x3CE4,
  0xD19C, 0x1C0C,
  0x7CFF, 0xB3F4,
  0x3FEC, 0xF06C,
  0x182E, 0x18C8,
  0x1C66, 0x08CC,
  0x1C43, 0x1866,
  0x0E61, 0x1062,
  0x0623, 0x10C6,
  0x0623, 0x10C4,
  0x0E23, 0x1864,
  0x0E66, 0x1824,
  0x0C46, 0x0C2C,
  0x0C02, 0x0C06,
  0x0C03, 0x0C02,
  0x1800, 0x0802
};


/* Robot probe boss sprite */
static unsigned short boss4Bits[] = {
  0x0000, 0x8000,
  0x0000, 0x8000,
  0x0000, 0x8000,
  0x0001, 0xC000,
  0x0003, 0xE000,
  0x000C, 0x1800,
  0x0030, 0xC600,
  0x0840, 0x7108,
  0x1C40, 0x191C,
  0x3E8C, 0x0CBE,
  0x1E92, 0x00BC,
  0x4DF3, 0xFFD9,
  0x6512, 0x0053,
  0x710C, 0x0047,
  0x7100, 0x0047,
  0x6100, 0x0047,
  0x6080, 0x0083,
  0x6090, 0x0083,
  0x6048, 0x0103,
  0x6146, 0x0143,
  0x61B0, 0x06C3,
  0x61CC, 0x19C3,
  0x61C3, 0xE1C3,
  0xC180, 0x0187,
  0xC380, 0x0187,
  0xC300, 0x00C7,
  0xC300, 0x00C6,
  0xC300, 0x00C6,
  0x4700, 0x00E2,
  0x0000, 0x0000,
  0xC600, 0x00E6,
  0xC600, 0x0066
};

/*UFO Stalker Sprite */
static unsigned short ufoBits[] = {
 0x0000,
 0x0000,
 0x0000,
 0x0FE0,
 0x10F0,
 0x2078,
 0xFFFE,
 0x5554,
 0x3FF8,
 0x0FF0,
 0x1108,
 0x0000,
 0x0000,
 0x0000,
 0x0000,
 0x0000
};

/* Main menu SFX ON sprite */
static unsigned short sfxOnBits[] = {
 0x0000,
 0x0000,
 0x0000,
 0x0100,
 0x0308,
 0x0704,
 0x3F24,
 0x3F12,
 0x3F12,
 0x3F12,
 0x3F24,
 0x0704,
 0x0308,
 0x0100,
 0x0000,
 0x0000
};

/* Main menu SFX MUTE sprite */
static unsigned short sfxOffBits[] = {
 0x0000,
 0x0000,
 0x0000,
 0x0100,
 0x0300,
 0x0721,
 0x3F12,
 0x3F0C,
 0x3F0C,
 0x3F0C,
 0x3F12,
 0x0F21,
 0x0300,
 0x0100,
 0x0000,
 0x0000
};

/* Main menu MUSIC ON sprite */
static unsigned short musicOnBits[] = {
  0x0000,
  0x0000,
  0x0000,
  0x0000,
  0x07FC,
  0x07FC,
  0x0404,
  0x07FC,
  0x0404,
  0x0404,
  0x3C3C,
  0x5C5C,
  0x7C7C,
  0x3838,
  0x0000,
  0x0000
};

/* Main menu MUSIC OFF sprite */
static unsigned short musicOffBits[] = {
  0x8001,
  0x4002,
  0x2004,
  0x1008,
  0x0FFC,
  0x07FC,
  0x0644,
  0x07FC,
  0x0584,
  0x0644,
  0x3C3C,
  0x5C5C,
  0x7C7C,
  0x383C,
  0x4002,
  0x8001
};




/* Put all the Boss sprites into an array so we can track and cycle through them in order */
unsigned short* gBossSprites[] = { boss1Bits, boss2Bits, boss3Bits, boss4Bits }; /* Names of the boss arrays. Add names if you draw more to pewpew! */
short gCurrentBossIndex = 0; /* Where are we in the Boss list? */
#define MAX_BOSS_TYPES 4 /* Total number of boss entries. Increase this if you add more Boss sprites */

/* Fun words to scroll along the bottom of the play screen */
/* If you add more, be sure to increate NUM_MESSAGES from 7 to however many you have! */
unsigned char* gEncouragement[NUM_MESSAGES] = { "\pINCOMING ASTEROIDS!", "\pWATCH FOR UFOS!", "\pNOT A GOOD DAY TO BE A ROCK!", "\pTRY NOT TO EXPLODE!", "\pSTAY ALERT!", "\pBIO-SIGN DETECTED!", "\pPEW! PEW! THAT GOT 'EM!" };
/* Pre calculated SINE path for the above text to follow so we avoid softFPU slowdown sadness */
static short gSineTable[32] = { 0, 24, 48, 70, 90, 106, 118, 125, 127, 125, 118, 106, 90, 70, 48, 24, 0, -24, -48, -70, -90, -106, -118, -125, -127, -125, -118, -106, -90, -70, -48, -24 };

/* --- Prototypes because, hey... it's 1994 again! :) --- */
void InitSoundManager(void);
void CleanUpSound(void);
void PlayPoolSound(Handle theSnd);
void LoadHighScore(void);
void SaveHighScore(long score);
void ShowSplashScreen(short pictID);
void InitializeSpace(void);
void CreateExplosion(short x, short y, short intensity);
void FireLaser(Point shipPos);
void UsePlasmaBomb(void);

/* Ok, this line is important... */
/* AABB (Axis-Aligned Bounding Box) Collision Detection. */
/* Checks if two rectangular areas overlap using high-speed integer comparisons. */
/* Returns true if the boxes intersect, false otherwise. */
Boolean FastIntersect(short x1, short y1, short w1, short h1, short x2, short y2, short w2, short h2);

void CheckCollisions(Point mousePos);
void UpdateSpace(Point mousePos);
void DrawToBuffer(Point mousePos);


/* --- Sound FX Functions --- */
/* This section plays a sound using a Round-Robin channel allocation system. */
/* Rotates through a pool of sound channels to allow multiple overlapping */
/* sound FX without cutting off currently playing audio. */
void PlayPoolSound(Handle theSnd) {
    if (theSnd && gSoundEnabled) {
        SndPlay(gSoundPool[gNextChannel], (SndListHandle)theSnd, true);
        gNextChannel++;
        if (gNextChannel >= kMaxChannels) gNextChannel = 0;
    }
}

/* Open the sound channels and load the sound files from the resource fork into memory */
void InitSoundManager() {
    short i;

	gBombGetSnd = GetResource('snd ', kBombGetSndID); /* Load the sound from the resource fork */
	if (gBombGetSnd) {
		HLock(gBombGetSnd); /* Lock the memory handle so the system can't move the memory where the sound is located and mess up playback */
		HNoPurge(gBombGetSnd); /* Mark the sound as non-purgeable so if memory gets low, this isn't removed from memory */
	}
    gBombBlastSnd = GetResource('snd ', kBombBlastSndID);
    if (gBombBlastSnd) {
    	HLock(gBombBlastSnd);
    	HNoPurge(gBombBlastSnd);
    }
    gLaserSnd = GetResource('snd ', kLaserSndID);
    if (gLaserSnd) {
    	HLock(gLaserSnd);
    	HNoPurge(gLaserSnd);
    }
    gExplodeSnd = GetResource('snd ', kExplodeSndID);
    if (gExplodeSnd) {
    	HLock(gExplodeSnd);
    	HNoPurge(gExplodeSnd);
    }
    gEnergyGetSnd = GetResource('snd ', kEnergyGetSndID);
    if (gEnergyGetSnd) {
    	HLock(gEnergyGetSnd);
    	HNoPurge(gEnergyGetSnd);
    }
    gEnergyBlastSnd = GetResource('snd ', kEnergyBlastSndID);
    if (gEnergyBlastSnd) {
    	HLock(gEnergyBlastSnd);
    	HNoPurge(gEnergyBlastSnd);
    }
    gUFOSnd = GetResource('snd ', kUFOSndID);
    if (gUFOSnd) {
    	HLock(gUFOSnd);
    	HNoPurge(gUFOSnd);
    }

    for (i = 0; i < kMaxChannels; i++) { /* Init the sound channel pool for multi-voice FX */
        gSoundPool[i] = NULL; /* Set the pointer to NULL so we start fresh */
        SndNewChannel(&gSoundPool[i], sampledSynth, 0, NULL); /* Allocate a new sound channel in SampledSynth for playing digital audio data. */
    }
}

/* When we're done with the sound, make sure all channel playback is stopped and release the memory holding the sound FX */
void CleanUpSound() {
    short i;
    for (i = 0; i < kMaxChannels; i++) if (gSoundPool[i]) SndDisposeChannel(gSoundPool[i], true); /* Stop playing sounds NOW and shutdown the sound system. Start freeing up memory */

    if (gLaserSnd) { /* Cleanup specific sound resource (this one is for the Laser SFX) */
    	HUnlock(gLaserSnd); /* Unlock the handle to the memory manager can move this block of memory again */
    	ReleaseResource(gLaserSnd); /* Remove this sound from RAM and release it back to the resource manager */
    }
    
    if (gExplodeSnd) {
    	HUnlock(gExplodeSnd);
    	ReleaseResource(gExplodeSnd);
    }
    
    if (gEnergyGetSnd) {
    	HUnlock(gEnergyGetSnd);
    	ReleaseResource(gEnergyGetSnd);
    }
    
    if (gEnergyBlastSnd) {
    	HUnlock(gEnergyBlastSnd);
    	ReleaseResource(gEnergyBlastSnd);
    }
    
    if (gUFOSnd) {
    	HUnlock(gUFOSnd);
    	ReleaseResource(gUFOSnd);
    }
    
    if (gBombGetSnd) {
    	HUnlock(gBombGetSnd);
    	ReleaseResource(gBombGetSnd);
    }
    
	if (gBombBlastSnd) {
		HUnlock(gBombBlastSnd);
		ReleaseResource(gBombBlastSnd);
	}
}

/* --- High score logic --- */
void LoadHighScore(void) {
    Handle h = Get1Resource('HiSc', 128); /* Grab the highest score achieved from the resource fork */
    if (h) {
    	gHighScore = **(long**)h;
    	ReleaseResource(h);
    } /* if there is a high score in the fork, grab it, if not... */
    else {
    	gHighScore = 0;
    } /* Set the high score to 0 if there isn't one in the resource fork */
}

void SaveHighScore(long score) {
    Handle h = Get1Resource('HiSc', 128); /* Look if the resource fork for resource HiSc with a specific ID of 128 exists */
    if (!h) {
        h = NewHandle(sizeof(long)); /* If NULL was returned (first time save), allocate space for it  */ 
        **(long**)h = score; /* Place the actual score value here */
        AddResource(h, 'HiSc', 128, "\pHigh Score"); /* Write the new high score to the resource fork in the HiSc, ID 128 location */
    } else {
    	**(long**)h = score; /* Score already exists in the resource fork, so overwrite it with the new value */
    	ChangedResource(h); /* Flag the resource as 'dirty' (no, not that kind of dirty...) so System knows RAM has changed */
    }
    WriteResource(h); /* Write the changes from memory's resource map to the physical disk */
}

/* Load the PICT splash image from the resource fork and display it for about 5 seconds (300 ticks) or a mouse click */
void ShowSplashScreen(short pictID) {
    PicHandle thePicture;
    Rect destRect;
    unsigned long finalTicks;
    thePicture = GetPicture(pictID);
    if (thePicture != NULL) {
        destRect = gWindow->portRect;
        SetPort(gWindow);
        DrawPicture(thePicture, &destRect);
        finalTicks = TickCount() + 300; 
        while (TickCount() < finalTicks) {
        	if (Button()) {
        		while (Button()) {
        		} break;
        	}
        }
        ReleaseResource((Handle)thePicture);
    }
}

/* Setup the visual aspects of the game for the player */
void InitializeSpace(void) {
    short i, j;
    for (i = 0; i < NUM_STARS; i++) {      /* from 0 to the NUM_STARS value (60) */
        starfield[i].x = abs(Random()) % WIN_WIDTH;  /* Randomly plot the stars positions on X */
        starfield[i].y = PLAY_AREA_TOP + (abs(Random()) % (PLAY_AREA_BOTTOM - PLAY_AREA_TOP)); /* Y random position for stats, constrained between the top and bottom areas */
        starfield[i].speed = (abs(Random()) % 3) + 1; /* Parallax depth. Assign a random value 0, 1, 2 to each star indicating foreground, middle or background. +1 to make the numbers 1, 2, 3 */
    }
	/* Lots of safety cleanup stuff below, to ensure coordinate data from previous games doesn't get picked up for the current game */
    for (i = 0; i < MAX_ASTEROIDS; i++) gAsteroids[i].active = false; /* Sets all asteroid slots to inactive, making sure no invisible ones exist from a previous game */
    for (i = 0; i < MAX_LASERS; i++) gLasers[i].active = false; /* Ensures no phantom laser blasts at startup from a previous game still in memory */
    for (i = 0; i < MAX_BOSS_SHOTS; i++) { /* Cleans out any remaining boss missiles from a previous game  */
        gBossShots[i].active = false; /* Turn off any potential missile that a boss could have shot in a previous game.  Safety first! */
        for(j=0; j<MAX_TRAIL; j++) {
        	gBossShots[i].trailX[j] = 0;
        	gBossShots[i].trailY[j] = 0;
        } /* Ensure the initial shot trail effect pixels start inside the current missile, not from a previous game's last position */
    }
    for (i = 0; i < MAX_PARTICLES; i++) gParticles[i].active = false; /* clear out any old particle explosion sparks */
    gBoss.active = false;
    gEnergyItem.active = false;
    gEnergyItem.x = -100; /* Ensure the Boss isn't waiting at the start of play, as well as making sure no free energy boost or plasma bomb is waiting for to at the start */
    gPlasmaItem.active = false;
    gPlasmaItem.x = -100; /* Not only reset the bonus items, but make sure they are physically off the screen.  No cheating! lol */ 
    gUFO.active = false;
    gUFOShot.active = false;
    gUFOShot.vy = 0; /* Resets the UFO enemy and it's velocity that could be hanging over from a previous game */
    gNextEnergyTick = TickCount() + 300; /* Energy pod timer. 300 ticks is ~5sec to prevent energy from appearing too quickly at the start of the game */
    
    /* Set the STATEs of the game below */
    gScore = 0;
    gHealth = 100;
    gBombCount = 0;
    gWarningTimer = 0;     /* All the default states are now set for a new game */
    gNewRecord = false;
    gNextBossScore = 500;
    gBossHitTimer = 0; 
    gCurrentBossIndex = 0; /* The boss sprite rotation starts at 0 */
    
    /* Setting up the sine wave scrolling text ticker. */
    gTicker.x = INT_TO_FIXED(WIN_WIDTH); /*  Stage the text just off screen to the right */
    gTicker.baseY = 270; /* the 'bobbing' path of the text */
    gTicker.angle = 0; /* The angle of the text */
    gTicker.msgIndex = 0; /* The actual text from gEncouragement[NUM_MESSAGES] */
        
    SetRect(&gAboutBtn, 85, 230, 185, 260);
    SetRect(&gStartBtn, 195, 230, 295, 260);
    SetRect(&gQuitBtn,  305, 230, 405, 260);      /* The dimensions for each of the rectangles making up our various buttons */
    SetRect(&gPlayAgainBtn, 220, 195, 300, 215); 
    SetRect(&gMuteRect, 15, 255, 31, 271);
	SetRect(&gMusicRect, 50, 255, 66, 271); /* Music icon next to SFX icon */
}

/* Super fun nifty particle explosion generator! */
/* Spawns a cluster of particles at a specific location. */
/* Uses an object pool to find inactive particles and initializes them */
/* with random trajectories to create the KABOOM effect. */
void CreateExplosion(short x, short y, short intensity) {
    short i, count = 0;
    PlayPoolSound(gExplodeSnd); /* Trigger the explosion sound effect using the round-robin pool */
    for (i = 0; i < MAX_PARTICLES && count < intensity; i++) { /* Iterate through the particle pool to find available (inactive) slots */
        if (!gParticles[i].active) {
            gParticles[i].active = true;
            gParticles[i].x = INT_TO_FIXED(x); /* Convert integer screen coordinates to Fixed-point for smoothness */
            gParticles[i].y = INT_TO_FIXED(y); /* Ditto */
            gParticles[i].vx = INT_TO_FIXED((abs(Random()) % 12) - 6); /* Assign random velocities. range is roughly -6.0 to +6.0 in Fixed-point */
            gParticles[i].vy = INT_TO_FIXED((abs(Random()) % 12) - 6);
            gParticles[i].life = 20 + (abs(Random()) % 20); /* Randomize lifespan (TTL) between 20 and 40 frames for a natural particle fade */
            count++; /* Track how many particles we've successfully spawned */
        }
    }
}

/* Pew Pew! Spawns a new laser projectile at the ship's current position. */
/* Searches the laser pool for an inactive slot, offsets the starting */
/* position to the ship's centre, and triggers the firing sound. */
void FireLaser(Point shipPos) {
    short i;
    for (i = 0; i < MAX_LASERS; i++) if (!gLasers[i].active) { /* Look through the laser pool to find an available slot */
        gLasers[i].x = shipPos.h + 8; /* Set start coordinates for the laser.  h + 8 and v + 8 centres the shot on a 16px wide sprite, which the ship is. */
        gLasers[i].y = shipPos.v;
        gLasers[i].active = true; /* Activate the laser (true) so UpdateSpace and DrawToBuffer will process it */
        PlayPoolSound(gLaserSnd);  /*Play the sound FX */
        break; /* Exit loop immediately after firing one shot to prevent embarrassing pre-mature laser-ation... (multi-firing) :) */
    }
}

/* If the player presses the SPACE BAR and has Plasma Bomb(s) in their inventory, good-bye on screen enemies! */
/* Check if Asteroids are on screen or a UFO and if so, award the appropriate points for the quantity on screen. */
/* Play the BombBlastSnd, loaded earlier from the resource fork. */
void UsePlasmaBomb(void) {
    short i;
    if (gBombCount > 0) { /* Do they even HAVE a plasma bomb? */
        gBombCount--; /* Reduce the bomb count by 1 */
        gFlashRequest = true; /* Invert the screen for a nice flash effect */
        PlayPoolSound(gBombBlastSnd); /* Plat the bomb sound FX */
        for (i = 0; i < MAX_ASTEROIDS; i++) { /* Check if and how many asteroids are on screen, explode them! Give points accordingly */
            if (gAsteroids[i].active) {
 				/* Find the H and V canters of the asteroid being destroyed. +8 on each to offsets the 16x16 sprite and be centred. 10 particles out of the pool being used */
                CreateExplosion(gAsteroids[i].x + 8, gAsteroids[i].y + 8, 10);
                gAsteroids[i].active = false; /* Set the flag back to false */
                gScore += 5; /* +5pts! WhooHoo! */
            }
        }
        if (gUFO.active) { /* Check if a UFO is on screen, explode it! Give points */
            /* Find the H and V centres of the UFO being destroyed. +8 on each to offsets the 16x16 sprite and be centred. 15 particles out of the pool being used */
			CreateExplosion(FIXED_TO_INT(gUFO.x) + 8, FIXED_TO_INT(gUFO.y) + 8, 15);
            gUFO.active = false; /* Reset the ufo status to false */
            gScore += 25; /* Add +25pts */
        }
    }
}

/* Collision detection magic! */
/* If any conditions fails, the check stops and returns a false instantly */
Boolean FastIntersect(short x1, short y1, short w1, short h1, short x2, short y2, short w2, short h2) {
    return (x1 < x2 + w2 && x1 + w1 > x2 && y1 < y2 + h2 && y1 + h1 > y2);
}

/* Collision Detection below... Processes interactions between game objects. */
void CheckCollisions(Point mousePos) {
    short i, j, sx = mousePos.h - 8, sy = mousePos.v - 8; /* Calculate ship's top-left corner (sx, sy) by centring the 16x16 sprite on the mouse */
	
	/* Shield Energy pods physical collision pickup*/
    if (gEnergyItem.active && FastIntersect(gEnergyItem.x, gEnergyItem.y, 16, 16, sx, sy, 16, 16)) { /* Check if the Energy Item is active and colliding with the player ship */
        gEnergyItem.active = false; /* Deactivate the item */
        gEnergyItem.x = -100; /* Move it off-screen to prevent double-collection */
        gHealth += 20;  /* Restore health energy by adding +20 */
        if (gHealth > 100) gHealth = 100; /* But cap it at the maximum of 100 */
        PlayPoolSound(gEnergyGetSnd); /* Play sound FX for the energy pickup */
    }
    
    /* The object collision logic below works on the exact same logic as above, but some objects have addition effects, etc... */
    
    /* Plasma bomb */
    if (gPlasmaItem.active && FastIntersect(gPlasmaItem.x, gPlasmaItem.y, 16, 16, sx, sy, 16, 16)) {
        gPlasmaItem.active = false;
        gPlasmaItem.x = -100;
        if (gBombCount < MAX_BOMBS) gBombCount++; /* Increment bomb inventory only if the player is below the maximum carrying capacity (5) */
        PlayPoolSound(gBombGetSnd);
    }
    
    /* Boss collission */
    if (gInvincTimer == 0) { /* Only process damage if the player's invulnerability frames (iframes) have expired */
        if (gBoss.active && FastIntersect(FIXED_TO_INT(gBoss.x), FIXED_TO_INT(gBoss.y), 32, 32, sx, sy, 16, 16)) { /* Same as above, but centring is based on 32x32 sprite */
            gHealth -= 20; gFlashRequest = true; /* High damage penalty for physical contact with the boss. It's your first date! */
            gShakeTimer = 10; /* Visually flash the screen / ship and trigger the screen shake effect for 10 frames*/
            gInvincTimer = 40; /* Set the ship to invincibility (take no damage) for 40 frames */
            CreateExplosion(mousePos.h, mousePos.v, 15); /* Spawn an explosion at the player's position to visualize the crash */
        }
        
        /* UFO Stalker collision */
        if (gUFO.active && FastIntersect(FIXED_TO_INT(gUFO.x), FIXED_TO_INT(gUFO.y), 16, 16, sx, sy, 16, 16)) {
            gHealth -= 15;
            gFlashRequest = true;
            gShakeTimer = 8;
            gInvincTimer = 30;
            CreateExplosion(mousePos.h, mousePos.v, 10);
        }
        
        /* Damn rocks! */
        /* Try not to collide wit them... ;) */
        for (i = 0; i < MAX_ASTEROIDS; i++) if (gAsteroids[i].active && FastIntersect(gAsteroids[i].x, gAsteroids[i].y, 16, 16, sx, sy, 16, 16)) {
            gAsteroids[i].active = false; /* Destroy the asteroid on impact... he's at least you took it with you... :) */
            gHealth -= 12; /* That hurt... -12 energy points */
            gFlashRequest = true; /* Screen flash */
            gInvincTimer = 30; /* Invincible for 30 frames */
            CreateExplosion(gAsteroids[i].x + 8, gAsteroids[i].y + 8, 20); /* KA-BLAMO! */
        }
    }
    
    /* The boss missiles */
    for (i = 0; i < MAX_BOSS_SHOTS; i++) if (gBossShots[i].active && FastIntersect(FIXED_TO_INT(gBossShots[i].x), FIXED_TO_INT(gBossShots[i].y), 2, 2, sx, sy, 16, 16)) {
        gBossShots[i].active = false;
        gHealth -= 4;
        gFlashRequest = true;
    }
    
    /* UFO missiles */    
    if (gUFOShot.active && FastIntersect(FIXED_TO_INT(gUFOShot.x), FIXED_TO_INT(gUFOShot.y), 2, 2, sx, sy, 16, 16)) { 
    	gUFOShot.active = false;
    	gHealth -= 5;
    	gFlashRequest = true;
    }
    
    /* Remote laser collection of shield energy pods */
    for (j = 0; j < MAX_LASERS; j++) { /* Loop through all player lasers to check for 'item-sniping' interactions */
        if (!gLasers[j].active) continue; /* Skip checking lasers that aren't currently on screen */
        if (gEnergyItem.active && FastIntersect(gLasers[j].x, gLasers[j].y, 10, 2, gEnergyItem.x, gEnergyItem.y, 16, 16)) { /* Check if a laser (10x2) hits an active Energy pod (16x16) */
            gLasers[j].active = false; /* Deactivate both the projectile and the item upon impact */
            gEnergyItem.active = false;
            gHealth += 10; /* Reward the player with half the health of a physical energy pod collision (+10 vs +20) */
            if (gHealth > 100) gHealth = 100; /* Cap energy health at 100 */
            CreateExplosion(gEnergyItem.x+8, gEnergyItem.y+8, 8); /* Explosions are cool, let's make a small one */
            PlayPoolSound(gEnergyBlastSnd); /* and play the energy blast sound */
            continue; /* Move to the next laser immediately; this one is spent */
        }
        
        /* Blow up the UFO stalker! */	
        if (gUFO.active && FastIntersect(gLasers[j].x, gLasers[j].y, 10, 2, FIXED_TO_INT(gUFO.x), FIXED_TO_INT(gUFO.y), 16, 16)) { /* Check if a laser strikes the Boss (32x32 bounding box) */
            gLasers[j].active = false; 
            gUFO.active = false;
            gScore += 50;
            CreateExplosion(FIXED_TO_INT(gUFO.x) + 8, FIXED_TO_INT(gUFO.y) + 8, 15);
            continue;
        }
        
        /* Boss damage and defeat logic */
        if (gBoss.active && FastIntersect(gLasers[j].x, gLasers[j].y, 10, 2, FIXED_TO_INT(gBoss.x), FIXED_TO_INT(gBoss.y), 32, 32)) {
            gLasers[j].active = false; /* Consume the laser and decrease Boss health */
            gBoss.hp--;
            gFlashRequest = true; /* Flash the screen */
            gBossHitTimer = 10; 
            if (gBoss.hp <= 0) { /* If Boss HP is 0, you got him! */
                gBoss.active = false; gGameState = STATE_PLAYING; gScore += 100; gHealth = 100; /* Back to the normal PLAYING game state, all +100 to the score and MAX out your energy health */
                CreateExplosion(FIXED_TO_INT(gBoss.x) + 16, FIXED_TO_INT(gBoss.y) + 16, 40); /* Create a massive explosion centred on the 32x32 Boss sprite */
                gCurrentBossIndex++; /* Progress to the next Boss type or cycle back to the first */
            if (gCurrentBossIndex >= MAX_BOSS_TYPES) gCurrentBossIndex = 0; /* If you just beat the last boss in the array, return to the first boss (0) */
            }
            continue; /* Continue on with the next laser check */
        }
        
        /* Blast asteroids with your laser, not your ship... */
        for (i = 0; i < MAX_ASTEROIDS; i++) if (gAsteroids[i].active && FastIntersect(gLasers[j].x, gLasers[j].y, 10, 2, gAsteroids[i].x, gAsteroids[i].y, 16, 16)) {
            gLasers[j].active = false;
            gAsteroids[i].active = false;
            gScore += 10;
            CreateExplosion(gAsteroids[i].x + 8, gAsteroids[i].y + 8, 12);
        }
    }
    
    /* Boss spawn logic */
	if (gScore >= gNextBossScore && !gBoss.active && gGameState == STATE_PLAYING) { /* Checks if the player has earned enough points to trigger the next Boss encounter (about every 500pts) */
    	gGameState = STATE_BOSS; /* Sets the state to BOSS so standard enemies stop spawning */
    	gBoss.active = true; /* Init the Boss! */
    	gBoss.x = INT_TO_FIXED(WIN_WIDTH); /* Position the Boss. Start it off-screen to the right (WIN_WIDTH) at a height of 100px */
    	gBoss.y = INT_TO_FIXED(100); 
    	gBoss.hp = 12; /* 12 hits to destroy the jerk */
    	gBossFireTimer = 10; /* Initialize the firing cooldown so the Boss doesn't shoot the instant it appears */
    	gNextBossScore += 500; /* Set the score goal for the next Boss (increasing the gap by 500 points) 500, 1000, 1500, 2000, etc... */
		}
	}
}

/* UpdateSpace: The core physics and movement loop. */
void UpdateSpace(Point mousePos) {
short i, k, count, shotsToFire;
		/* This section pre-calculates the Y-axis offsets for the Boss's triple-shot attack. */
		/* Use static so this is only initialized once in memory */ 
static Fixed spreadY[3] = { 0, 0, 0 }; 
if (spreadY[1] == 0) {
	spreadY[0] = 0;
	spreadY[1] = FL_TO_FIXED(-1.8);
	spreadY[2] = FL_TO_FIXED(1.8);
}


/* 1988 Amiga Demoscene style parallax star field background! */
/* Moves stars to the left and recycles them to the right side when they */
/* exit the screen, creating a continuous scrolling effect. */
    for (i = 0; i < NUM_STARS; i++) { 
        starfield[i].x -= starfield[i].speed; /* Move the star left based on its individual speed (multi-layered parallax) */
        if (starfield[i].x < 0) { /* If the star moves off the left edge of the screen... */
        	starfield[i].x = WIN_WIDTH; /* Wrap it back to the far right edge */
        	starfield[i].y = PLAY_AREA_TOP + (abs(Random()) % (PLAY_AREA_BOTTOM - PLAY_AREA_TOP)); /* Randomize its new vertical position within the play area */
        }
    }
    
    
    if (gGameState == STATE_PLAYING || gGameState == STATE_BOSS) {
        gTicker.x -= INT_TO_FIXED(3); /* Move the text ticker to the left at a constant speed of 3 pixels per frame */
        gTicker.angle = (gTicker.angle + 1) & 31; /* Increment the sine table index (masking with 31 to keep it within the 0-31 range) */
        gTicker.currentY = gTicker.baseY + (gSineTable[gTicker.angle] / 16); /* Apply a vertical bobbing effect by fetching a value from the pre-calculated sine table */
        if (FIXED_TO_INT(gTicker.x) < -250) { /* If the text has moved entirely off-screen to the left (-250px), reset it */
        	gTicker.x = INT_TO_FIXED(WIN_WIDTH); /* Wrap back to the right edge */
        	if (++gTicker.msgIndex >= NUM_MESSAGES) gTicker.msgIndex = 0; /* Cycle to the next string in your message array */
        }
        
        
        /* Player invincibility timer */
        if (gInvincTimer > 0) gInvincTimer--; /* Countdown the invincibility frames (i-frames) provided after taking a hit */
        
        /* Low Health Alert */
        if (gHealth <= 25) gWarningTimer++; /* If energy health is below 25%, flash the warning */
        	else gWarningTimer = 0;
        
        /* UFO Stalker spawning */
        if (!gUFO.active && (abs(Random()) % 400) == 0) { /* Randomly spawn a UFO if one isn't currently active */
            gUFO.active = true;
            gUFO.x = INT_TO_FIXED(-30); /* Start the UFO off-screen to the left (-30px) */
            gUFO.targetX = 50; /* Set a target position; it will fly in until it reaches x=50 */
            gUFO.y = INT_TO_FIXED(100); /* Initial vertical starting position */
            gUFO.bobDir = 1; /* Initialize vertical movement direction (1 = down, -1 = up) for the hovering effect */
            gUFO.fireTimer = 50; /* Set the initial firing cooldown so it doesn't shoot immediately upon entry */
            PlayPoolSound(gUFOSnd); /* Play the distinctive UFO arrival hum sound... HOVER BIKES!!!!!!!*/
        }
        
        if (gUFO.active) {
            if (FIXED_TO_INT(gUFO.x) < gUFO.targetX) gUFO.x += FL_TO_FIXED(1.5); gUFO.y += INT_TO_FIXED(gUFO.bobDir);
            if (FIXED_TO_INT(gUFO.y) > (PLAY_AREA_BOTTOM - 20) || FIXED_TO_INT(gUFO.y) < (PLAY_AREA_TOP + 10)) gUFO.bobDir *= -1; /* Boundary Check. Reverse vertical direction if the UFO hits the top or bottom of the play area */
            if (--gUFO.fireTimer <= 0) {
                if (!gUFOShot.active) { /* Only fire if the previous shot has finished/deactivated. So 1 missile at a time */
                    gUFOShot.active = true;
                    gUFOShot.x = gUFO.x + INT_TO_FIXED(16); /* Center of the 16x16 UFO */
                    gUFOShot.y = gUFO.y + INT_TO_FIXED(8);
                    gUFOShot.vy = 0;
                    for(k=0; k<MAX_TRAIL; k++) { /* Initialize the projectile's ghost trail so it doesn't flicker on frame 1 */
                    	gUFOShot.trailX[k] = FIXED_TO_INT(gUFOShot.x);
                    	gUFOShot.trailY[k] = FIXED_TO_INT(gUFOShot.y);
                    }
                }
                gUFO.fireTimer = 120; /* UFO fires roughly every 2-4 seconds depending on frame rate */
            } if (FIXED_TO_INT(gUFO.x) > WIN_WIDTH + 100) gUFO.active = false; /* Deactivate UFO if it somehow drifts too far off-screen */
        }
        
        /* UFO Homing Missile Logic (Kinda proud of this one) :) */
        if (gUFOShot.active) {
        	/* Trails: Shift the 'history' of positions back by one frame so the oldest position is discarded, and the current one is added at index 0. */
            for(k=MAX_TRAIL-1; k>0; k--) {
            	gUFOShot.trailX[k] = gUFOShot.trailX[k-1];
            	gUFOShot.trailY[k] = gUFOShot.trailY[k-1];
            }
            gUFOShot.trailX[0] = FIXED_TO_INT(gUFOShot.x);
            gUFOShot.trailY[0] = FIXED_TO_INT(gUFOShot.y);
            
            /* HOMING BEHAVIOUR: Adjust vertical velocity (vy) to track the player's ship */
            if (FIXED_TO_INT(gUFOShot.y) < mousePos.v - 2) gUFOShot.vy += FL_TO_FIXED(0.15); /* Accelerate downward toward player */
            	else if (FIXED_TO_INT(gUFOShot.y) > mousePos.v + 2) gUFOShot.vy -= FL_TO_FIXED(0.15); /*Accelerate upward toward player */
            if (gUFOShot.vy > INT_TO_FIXED(2)) gUFOShot.vy = INT_TO_FIXED(2); /* SPEED CLAMPING: Limit vertical steering speed so the missile isn't unfairly agile */
            if (gUFOShot.vy < INT_TO_FIXED(-2)) gUFOShot.vy = INT_TO_FIXED(-2);
            gUFOShot.x += FL_TO_FIXED(4.5); /* POSITION INTEGRATION: Apply constant horizontal speed and variable vertical velocity */
            gUFOShot.y += gUFOShot.vy;
            /* BOUNDARY CLEANUP: Deactivate if the missile leaves the play area */
            if (FIXED_TO_INT(gUFOShot.x) > WIN_WIDTH || FIXED_TO_INT(gUFOShot.y) < PLAY_AREA_TOP || FIXED_TO_INT(gUFOShot.y) > PLAY_AREA_BOTTOM) gUFOShot.active = false;
        }
        
    /* Boss movements, actions and ANGRY EYES mode! */    
	if (gBoss.active) {
		gBoss.pulse = (gBoss.pulse + 1) & 31; /* ANIMATION: Cycle the pulse counter (0-31) for visual effects */
		if (gBoss.hp > 6) { /* Phase based movements */
			gBoss.x -= FL_TO_FIXED(0.7); /* Phase 1: Slow horizontal drift only */
			} else {
				gBoss.x -= FL_TO_FIXED(0.9); /* Phase 2: Increased horizontal speed and Active Vertical Tracking */
				if (FIXED_TO_INT(gBoss.y) + 16 < mousePos.v) gBoss.y += INT_TO_FIXED(2); /* Homing: Move the Boss vertically to align its centre (+16) with the player's Y position */
				else if (FIXED_TO_INT(gBoss.y) + 16 > mousePos.v) gBoss.y -= INT_TO_FIXED(2);
			}
			if (FIXED_TO_INT(gBoss.x) < -50) { /* ESCAPE PENALTY: If the player fails to destroy the Boss before it leaves the screen... */
				gBoss.active = false;
				gGameState = STATE_PLAYING;
				gHealth -= 30; /* Big damage penalty for letting a Boss escape */
			}
			/* ATTACK LOGIC: Firing projectiles */
			if (gBossFireTimer > 0) {
				gBossFireTimer--;
			} else {
				count = 0;
				shotsToFire = (gBoss.hp > 6) ? 1 : 3; /* Determine attack volume: 1 shot if healthy, 3 shots if 'really pissed off' */
				for(i = 0; i < MAX_BOSS_SHOTS && count < shotsToFire; i++) {
					if(!gBossShots[i].active) {
						gBossShots[i].active = true;
						gBossShots[i].x = gBoss.x;
						gBossShots[i].y = gBoss.y + INT_TO_FIXED(16); /* Fire from Boss centre */
						gBossShots[i].vx = INT_TO_FIXED(-4);
						gBossShots[i].vy = spreadY[count]; /* Apply spread pattern to the 3 missiles. spreadY[0]=0, spreadY[1]=-1.8, spreadY[2]=1.8 */
						/* Initialize motion trail to prevent 'streaking' on the first frame */
						for(k = 0; k < MAX_TRAIL; k++) {
							gBossShots[i].trailX[k] = FIXED_TO_INT(gBossShots[i].x);
							gBossShots[i].trailY[k] = FIXED_TO_INT(gBossShots[i].y);
						} count++;
					}
				}
			gBossFireTimer = (gBoss.hp > 6) ? 80 : 50; /* Phase 2 also fires significantly faster (50 frame reset vs 80) */
		}
	}
	
	/* --- Boss Projectile Movement Loop --- */
	for (i = 0; i < MAX_BOSS_SHOTS; i++) {
		if(gBossShots[i].active) {
			/* TRAIL SLIDE: Shift the history of previous positions */
			/* This creates the data structure we use for drawing motion blurs. */
			for(k = MAX_TRAIL - 1; k > 0; k--) {
				gBossShots[i].trailX[k] = gBossShots[i].trailX[k-1];
				gBossShots[i].trailY[k] = gBossShots[i].trailY[k-1];
			}
			/* Store the current position as an integer into the start of the trail */
			gBossShots[i].trailX[0] = FIXED_TO_INT(gBossShots[i].x);
			gBossShots[i].trailY[0] = FIXED_TO_INT(gBossShots[i].y);
			/* Move the shot based on its pre-defined velocity */
			gBossShots[i].x += gBossShots[i].vx;
			gBossShots[i].y += gBossShots[i].vy;
			/* Delete the projectile if it leaves the playable area. */
            /* The -20/+20 padding ensures the projectile fully exits the screen before deleting. IT'S A GHOST MISSILE! :D */
         	if(FIXED_TO_INT(gBossShots[i].x) < -20 || FIXED_TO_INT(gBossShots[i].x) > WIN_WIDTH + 20 || FIXED_TO_INT(gBossShots[i].y) < PLAY_AREA_TOP || FIXED_TO_INT(gBossShots[i].y) > PLAY_AREA_BOTTOM) {
				gBossShots[i].active = false;
			}
		}
	}
    for (i=0; i<MAX_BOSS_SHOTS; i++) if(gBossShots[i].active) { 
    	for(k=MAX_TRAIL-1; k>0; k--) {
    		gBossShots[i].trailX[k] = gBossShots[i].trailX[k-1];
            gBossShots[i].trailY[k] = gBossShots[i].trailY[k-1];
        }
        gBossShots[i].trailX[0] = FIXED_TO_INT(gBossShots[i].x);
        gBossShots[i].trailY[0] = FIXED_TO_INT(gBossShots[i].y);
        gBossShots[i].x += gBossShots[i].vx;
        gBossShots[i].y += gBossShots[i].vy;
        if(FIXED_TO_INT(gBossShots[i].x) < -20 || FIXED_TO_INT(gBossShots[i].y) < PLAY_AREA_TOP) gBossShots[i].active = false; 
	}
	
	/* Asteroid life cycle manager */
    for (i = 0; i < MAX_ASTEROIDS; i++) {
    	if (gAsteroids[i].active) {
        	gAsteroids[i].x -= gAsteroids[i].speed; /* Move the asteroid to the left */
            	if (gAsteroids[i].x < -20) { /* If the asteroid escapes past the left edge (-20px), the player is -10 health energy. */
            		gAsteroids[i].active = false;
            		gHealth -= 10; /* Don't let them get past you! */
            		gFlashRequest = true;
            	}
            }
            /* If the slot is empty and we are in standard play mode, spawn a new asteroid! */
            else if (gGameState == STATE_PLAYING && (abs(Random()) % 45) == 0) {
            	gAsteroids[i].active = true;
            	gAsteroids[i].x = WIN_WIDTH + 10; /* Start just off the right edge */
            	gAsteroids[i].y = (PLAY_AREA_TOP + 5) + (abs(Random()) % (PLAY_AREA_BOTTOM - PLAY_AREA_TOP - 20)); /* Randomize vertical position within the play area bounds */
            	gAsteroids[i].speed = (abs(Random()) % 3) + 2; /* Randomize speed between 2 and 4 pixels per frame */
            }
        }
        
		/* --- ENERGY POD Life Cycle --- */
		if (!gEnergyItem.active && TickCount() > gNextEnergyTick) { /* If no pod is active, check the system clock (TickCount) */
    		gEnergyItem.active = true; 
    		gEnergyItem.x = WIN_WIDTH + 10; /* Position the pod just off-screen to the right */
    		gEnergyItem.y = (PLAY_AREA_TOP + 5) + (abs(Random()) % (PLAY_AREA_BOTTOM - PLAY_AREA_TOP - 20)); /* Randomize vertical position within the play area */
    		gNextEnergyTick = TickCount() + 600; /* Spawns every ~10 seconds */
		}
		if (gEnergyItem.active) { /* If a pod exists, move it across the screen */
    		gEnergyItem.x -= 2; /* Move left at a fixed, predictable speed of 2 pixels per frame */
    		if (gEnergyItem.x < -30) gEnergyItem.active = false; /* Deactivate the pod if it scrolls off the left edge without being collected */
		}
		
		/* --- PLASMA BOMB SPAWNING --- */
		/* Check for an empty slot, check bomb count and roll a 1-in-400 chance */
		if (!gPlasmaItem.active && gBombCount < MAX_BOMBS && (abs(Random()) % 400) == 0) { 
    		gPlasmaItem.active = true; 
    		gPlasmaItem.x = WIN_WIDTH + 10; 
    		/* Spawn with a slightly tighter vertical margin than the asteroids */
    		gPlasmaItem.y = (PLAY_AREA_TOP + 20) + (abs(Random()) % (PLAY_AREA_BOTTOM - PLAY_AREA_TOP - 40)); 
		}
		if (gPlasmaItem.active) { 
    		gPlasmaItem.x -= 3; /* Plasma Bombs move faster (3px) than Energy Pods (2px) per frame */
    		if (gPlasmaItem.x < -30) gPlasmaItem.active = false; /* Deactivate if it goes off screen */
			}
        	CheckCollisions(mousePos);
        	for (i = 0; i < MAX_LASERS; i++) if (gLasers[i].active) {
        		gLasers[i].x += 12;
        		if (gLasers[i].x > WIN_WIDTH) gLasers[i].active = false;
        	}
        	if (gHealth <= 0) {
        		gGameState = STATE_GAMEOVER; /* If the players energy health reaches 0, change the state to GAMEOVER */
        		InitCursor();
        		for (i = 0; i < MAX_PARTICLES; i++) gParticles[i].active = false;
        		if (gScore > gHighScore) {
        			gHighScore = gScore;
        			gNewRecord = true;
        			SaveHighScore(gHighScore);
        		}
        	}
        	/* If the player achieved a new high score, queue the firework explosions! */
    } else if (gGameState == STATE_GAMEOVER && gNewRecord && (abs(Random()) % 25) == 0) CreateExplosion(50 + (abs(Random()) % (WIN_WIDTH - 100)), 50 + (abs(Random()) % (WIN_HEIGHT - 100)), 10);
    for (i = 0; i < MAX_PARTICLES; i++) if (gParticles[i].active) {
    	gParticles[i].x += gParticles[i].vx;
    	gParticles[i].y += gParticles[i].vy;
    	if (gGameState == STATE_GAMEOVER) gParticles[i].vy += (INT_TO_FIXED(2) / 10);
    	if (--gParticles[i].life <= 0) gParticles[i].active = false;
    }
}


/* This is where all the OFF SCREEN drawing magic happens */
void DrawToBuffer(Point mousePos) {
    GDHandle oldDevice;       /* Stores the current monitor info */
    GWorldPtr oldPort;        /* Stores the current window context (so we can switch back) */
    Rect r, hR, iconR, fullR; /* Rectangle structures for drawing sprites and UI */
    BitMap bm;                /* Used when we need to copy raw bits to the screen */
    Str255 s;                 /* A Pascal-style string for drawing text (Score, Health) */
    short i, k, pSize;        /* Loop counters and variable for particle sizing */
    PixMapHandle hPixMap;     /* A handle to the actual pixel data of the off-screen buffer */

    hPixMap = GetGWorldPixMap(gOffscreen);  /* Fetches the pixel map from the offscreen GWorld */
    LockPixels(hPixMap);  /* Lock the memory handling the gWorld off screen area so the system can't alter it */
    GetGWorld(&oldPort, &oldDevice); /* Saves the 'old' state (the visible window) so we don't lose track of it */
    SetGWorld(gOffscreen, NULL); /* Redirects all following drawing commands (Rects, Lines, Text) to the 'gOffscreen' buffer instead of the screen. */

    BackColor(blackColor); /* Sets the 'background' colour for the EraseRect command (black) */
    ForeColor(whiteColor); /* Sets the 'ink' colour for text and lines (white) */
    EraseRect(&gOffscreen->portRect); /* Wipes the entire buffer clean using the BackColour (Black). This prevents "ghosting" from the previous frame. */
    TextFont(0); /* Set the active font to the system font (usually Chicago) for the HUD, etc..*/

    /* --- Draw Background Stars --- */
    for (i = 0; i < NUM_STARS; i++) { 
        MoveTo(starfield[i].x, starfield[i].y); 
        Line(0, 0); /* Sneaky 0, 0 line draw will draw a single pixel at the current pen position.. a star is born! */
    }
    
	/* Draw the Main Menu components */
    if (gGameState == STATE_START) {
        TextSize(24);
        MoveTo(100, 40);
        DrawString("\pOPERATION : PewPew!"); 
        
        TextSize(10);
        MoveTo(210, 65);
        DrawString("\pHIGH SCORE: ");
        NumToString(gHighScore, s);
        DrawString(s);
        
        bm.rowBytes = 2; /* Define the memory width */
        SetRect(&bm.bounds, 0, 0, 16, 16); /* Define the bitmap size 16x16 */
       
        /* Display the main menu cast of characters, with their sprites and descriptive text beside them */
        bm.baseAddr = (Ptr)shipBits;
        SetRect(&iconR, 60, 85, 76, 101);
        CopyBits(&bm, (BitMap*)*hPixMap, &bm.bounds, &iconR, srcOr, NULL);
        MoveTo(90, 97);
        DrawString("\pYOU - Pew Pew!");
        
        bm.baseAddr = (Ptr)asteroidBits;
        SetRect(&iconR, 115, 110, 131, 126);
        CopyBits(&bm, (BitMap*)*hPixMap, &bm.bounds, &iconR, srcOr, NULL);
        MoveTo(140, 122);
        DrawString("\pAsteroid");
        
        bm.baseAddr = (Ptr)ufoBits;
        SetRect(&iconR, 170, 135, 186, 151);
        CopyBits(&bm, (BitMap*)*hPixMap, &bm.bounds, &iconR, srcOr, NULL);
        MoveTo(195, 147);
        DrawString("\pUFO Stalker");
        
        bm.baseAddr = (Ptr)energyBits;
        SetRect(&iconR, 215, 160, 233, 176);
        CopyBits(&bm, (BitMap*)*hPixMap, &bm.bounds, &iconR, srcOr, NULL);
        MoveTo(240, 172); DrawString("\pShield Energy Pod");
        
        bm.baseAddr = (Ptr)bombBits;
        SetRect(&iconR, 260, 185, 276, 201);
        CopyBits(&bm, (BitMap*)*hPixMap, &bm.bounds, &iconR, srcOr, NULL);
        MoveTo(285, 197);
        DrawString("\pPlasma Bomb");
        
        TextSize(9); MoveTo(170, 275); DrawString("\p[ESC] Returns to Menu anytime"); /*A little reminder text that ESC will exit the game */
        TextSize(8); MoveTo(15, 280); DrawString("\pSFX"); /* SFX label */
        TextSize(8); MoveTo(45, 280); DrawString("\pMusic"); /* Music label */

        bm.baseAddr = gSoundEnabled ? (Ptr)sfxOnBits : (Ptr)sfxOffBits; /* Mute or Unmute the SFX */
        CopyBits(&bm, (BitMap*)*hPixMap, &bm.bounds, &gMuteRect, srcOr, NULL); /* Display the appropriate sfx sprite */
        
        bm.baseAddr = gMusicEnabled ? (Ptr)musicOnBits : (Ptr)musicOffBits; /* Mute or Unmute htte MUSIC */
        CopyBits(&bm, (BitMap*)*hPixMap, &bm.bounds, &gMusicRect, srcOr, NULL); /* Display the appropriate music sprite */
        
        TextSize(12); 
        
        FrameRect(&gAboutBtn);
        MoveTo(117, 250);
        DrawString("\pABOUT");
        
        FrameRect(&gStartBtn);
        MoveTo(228, 250);
        DrawString("\pSTART");          /* Draw the 3 rectangle choices on the main menu */
        
        FrameRect(&gQuitBtn);
        MoveTo(340, 250);
        DrawString("\pQUIT");
        
        
        /* Invert the various button colours on mouse over */
        /* So the player knows what's clickable */
        if (PtInRect(mousePos, &gAboutBtn)) InvertRect(&gAboutBtn);
        if (PtInRect(mousePos, &gStartBtn)) InvertRect(&gStartBtn);
        if (PtInRect(mousePos, &gQuitBtn))  InvertRect(&gQuitBtn);
        if (PtInRect(mousePos, &gMuteRect)) InvertRect(&gMuteRect);
        if (PtInRect(mousePos, &gMusicRect)) InvertRect(&gMusicRect);
        
        /*clicking ABOUT sets the game's state to 4 (STATE_ABOUT) and displays the following 'About' screen. */
        /* What an epic story! */
    } else if (gGameState == STATE_ABOUT) {
        TextSize(24);
        MoveTo(100, 40);
        DrawString("\pOPERATION : PewPew!"); 
        TextSize(12);
        MoveTo(40, 70);
        DrawString("\pDue to a scheduling conflict involving sand, lava and dramatic");
        MoveTo(50, 90);
        DrawString("\pmusic, Obi Wan is unavailable... Making YOU our only hope!");
        MoveTo(92, 130);
        DrawString("\pMove your ship with the mouse, click to FIRE!");
        MoveTo(30, 150);
        DrawString("\pRude asteroids drift across the screen, trying to reach the left...");
        MoveTo(170, 170);
        DrawString("\pI wouldn't let them...");
        MoveTo(40, 190);
        DrawString("\pBlast pesky alien UFOs (probably trying to steal your pizza!)");
        MoveTo(80, 210);
        DrawString("\pWatch for energy packs to restore your shields!");
        MoveTo(55, 240);
        DrawString("\pCan you defeat the boss and win the ultimate High Score?");
        TextSize(9);
        MoveTo(160, 270);
        DrawString("\pCLICK ANYWHERE TO RETURN TO MENU");

	/* The boss is activated by either 'B' or the players score */
    } else if (gGameState == STATE_PLAYING || gGameState == STATE_BOSS) {
        /* HUD Shield Bar */
        if (gHealth > 25 || ((gWarningTimer / 10) % 2 == 0)) {
            SetRect(&hR, 15, 10, 115, 20); FrameRect(&hR); 
            /* Display the boss health energy bar */
            if (gHealth > 0) {
            	SetRect(&hR, 16, 11, 15 + gHealth, 19);
            	PaintRect(&hR);
            	}
            TextSize(9);
            MoveTo(15, 32);
            DrawString("\pSHIELD ENERGY"); /* Print the title SHIELD ENERGY under the players energy health bar */
        }
        
        /* Plasma Bomb Inventory in HUD */
        bm.baseAddr = (Ptr)bombBits;
        bm.rowBytes = 2;
        SetRect(&bm.bounds, 0, 0, 16, 16); /* Use the bombBits bitmap created way back at the start */
        
        for (i = 0; i < gBombCount; i++) { 
            SetRect(&iconR, 130 + (i * 18), 10, 146 + (i * 18), 26);  /* Define the rectangular shape around the bomb sprite */
            CopyBits(&bm, (BitMap*)*hPixMap, &bm.bounds, &iconR, srcOr, NULL); /* Display the bomb sprite in the HUD and uses srcOr to ensure the sprite is transparent */
        }

        /* Boss Specific HUD & Missiles */
        if (gBoss.active) {
            Rect bHR; short currentBarWidth, jiggle = 0; 
            if (gBossHitTimer > 0) { jiggle = gSineTable[gBossHitTimer & 31] >> 5; gBossHitTimer--; }
            SetRect(&bHR, BOSS_BAR_LEFT + jiggle, BOSS_BAR_TOP, BOSS_BAR_LEFT + BOSS_BAR_WIDTH + jiggle, BOSS_BAR_TOP + 8);
            FrameRect(&bHR); 
            currentBarWidth = (gBoss.hp * 100) / 12; 
            if (currentBarWidth > 0) { 
                Rect fillR; 
                SetRect(&fillR, (BOSS_BAR_LEFT + 1) + jiggle, BOSS_BAR_TOP + 1, (BOSS_BAR_LEFT + currentBarWidth) + jiggle, BOSS_BAR_TOP + 7); 
                PaintRect(&fillR); 
            }
            /* Display the text label for the boss energy health bar in he HUD */
            TextSize(9);
            MoveTo(BOSS_BAR_LEFT + jiggle, BOSS_BAR_TOP + 18);
            DrawString("\pBOSS HEALTH");
        }
        
        /* Draw Boss Missiles 3x3 */
        for (i = 0; i < MAX_BOSS_SHOTS; i++) {
            if (gBossShots[i].active) {
            	/*Convert fixed values to integers */
                SetRect(&r, FIXED_TO_INT(gBossShots[i].x), FIXED_TO_INT(gBossShots[i].y), FIXED_TO_INT(gBossShots[i].x) + 3, FIXED_TO_INT(gBossShots[i].y) + 3);
                PaintRect(&r); /* Fill the 3x3 missile area. */
                for (k = 0; k < MAX_TRAIL; k++) {
                    MoveTo(gBossShots[i].trailX[k], gBossShots[i].trailY[k]); /* Missile trails */
                    Line(0, 0);  /* Sneaky QuickDraw trick to draw a single pixel at the current pen location */
                }
            }
        }

        /* UFO Shot 2x2 */
        if (gUFOShot.active) {
            for(k = 0; k < MAX_TRAIL; k++) {
            	MoveTo(gUFOShot.trailX[k], gUFOShot.trailY[k]);
            	Line(0,0); /* UFO missile, there's that sneaky QuickDraw trail pixel trick again */
            }             
            SetRect(&r, FIXED_TO_INT(gUFOShot.x), FIXED_TO_INT(gUFOShot.y), FIXED_TO_INT(gUFOShot.x)+2, FIXED_TO_INT(gUFOShot.y)+2);
            PaintRect(&r); /* fill in the missile rectangle */
        }

		/* Draw the players current score in the HUD */
        TextSize(12);
        NumToString(gScore, s);
        MoveTo(380, 25); DrawString("\pScore: ");
        DrawString(s); 
               
        /* Draw the SINE scrolling text at the bottom of the screen */       
        TextSize(18);
        MoveTo(FIXED_TO_INT(gTicker.x), gTicker.currentY);
        DrawString(gEncouragement[gTicker.msgIndex]);
              
        /* Draw the 2 horizontal lines creating the top, middle, bottom regions */
        MoveTo(0, PLAY_AREA_TOP);
        LineTo(WIN_WIDTH, PLAY_AREA_TOP);
        MoveTo(0, PLAY_AREA_BOTTOM);
        LineTo(WIN_WIDTH, PLAY_AREA_BOTTOM);
              
        /* UFO Stalker drawing */  
        if (gUFO.active) {
        	bm.baseAddr = (Ptr)ufoBits;
            bm.rowBytes = 2;
            SetRect(&bm.bounds, 0, 0, 16, 16); /* Draw the UFO sprite */
            SetRect(&r, FIXED_TO_INT(gUFO.x), FIXED_TO_INT(gUFO.y), FIXED_TO_INT(gUFO.x) + 16, FIXED_TO_INT(gUFO.y) + 16); 
            CopyBits(&bm, (BitMap*)*hPixMap, &bm.bounds, &r, srcOr, NULL); /* Uses srcOr mode again to make the sprite transparent */
        	}
        
        /* Pulsing the boss sprite drawing */
        if (gBoss.active) { 
            pSize = gSineTable[gBoss.pulse] / 40; /* Pulsing the boss sprite */
            bm.baseAddr = (Ptr)gBossSprites[gCurrentBossIndex]; /* Select the correct bitmap from the rotating boss selection */
            bm.rowBytes = 4; /* 32x32 */
            SetRect(&bm.bounds, 0, 0, 32, 32);
            /* Create the 'pulse' by subtracting pSize from the top/left and adding it to the bottom/right, the boss grows and shrinks from its centre. */
            SetRect(&r, FIXED_TO_INT(gBoss.x) - pSize, FIXED_TO_INT(gBoss.y) - pSize, FIXED_TO_INT(gBoss.x) + 32 + pSize, FIXED_TO_INT(gBoss.y) + 32 + pSize); 
            /* Copies pixels from the source (bm) to the offscreen buffer (*hPixMap). */
       		/* QuickDraw automatically scales the 32x32 sprite to fit the stretched 'r' rect. */
       		/* 'srcOr' ensures the background isn't wiped out by black pixels. */
            CopyBits(&bm, (BitMap*)*hPixMap, &bm.bounds, &r, srcOr, NULL); 
        }

		/* Asteroid drawing */
        bm.rowBytes = 2; SetRect(&bm.bounds, 0, 0, 16, 16); 
        bm.baseAddr = (Ptr)asteroidBits;
        for (i = 0; i < MAX_ASTEROIDS; i++) if (gAsteroids[i].active) {
        	SetRect(&r, gAsteroids[i].x, gAsteroids[i].y, gAsteroids[i].x+16, gAsteroids[i].y+16);
        	CopyBits(&bm, (BitMap*)*hPixMap, &bm.bounds, &r, srcOr, NULL);
        }
        
        /* Energy Health Pod drawing */
        if (gEnergyItem.active) {
        	bm.baseAddr = (Ptr)energyBits;
        	SetRect(&r, gEnergyItem.x, gEnergyItem.y, gEnergyItem.x+16, gEnergyItem.y+16);
        	CopyBits(&bm, (BitMap*)*hPixMap, &bm.bounds, &r, srcOr, NULL);
        }
        
        /* Plasma Bomb drawing */
        if (gPlasmaItem.active) {
        	bm.baseAddr = (Ptr)bombBits;
        	SetRect(&r, gPlasmaItem.x, gPlasmaItem.y, gPlasmaItem.x+16, gPlasmaItem.y+16);
        	CopyBits(&bm, (BitMap*)*hPixMap, &bm.bounds, &r, srcOr, NULL);
        }
        
        /* Pew pew! Laser drawing! */
        for (i = 0; i < MAX_LASERS; i++) if (gLasers[i].active) {
        	SetRect(&r, gLasers[i].x, gLasers[i].y, gLasers[i].x + 8, gLasers[i].y + 2);
        	PaintRect(&r);
        }
        
        /* Momentary invincibility for the player's ship drawing */
        if (gInvincTimer % 4 < 2) {
        	bm.baseAddr = (Ptr)shipBits;
        	SetRect(&r, mousePos.h-8, mousePos.v-8, mousePos.h+8, mousePos.v+8);
        	CopyBits(&bm, (BitMap*)*hPixMap, &bm.bounds, &r, srcOr, NULL);
        }

    } else if (gGameState == STATE_GAMEOVER) { /* If a GAMEOVER state has been triggered... */
        TextSize(24); MoveTo(145, 120); /* Set a big font size and move to around the upper middle of the screen */
        if (gNewRecord) DrawString("\pNEW HIGH SCORE!"); /* If gNewRecord indicates a new high score, display this line */
        	else {
        		MoveTo(190, 90);
        		DrawString("\pGAME OVER");
        	} 
        	/* No matter what, display the text and button below */
        	TextSize(12); NumToString(gScore, s);
        	MoveTo(226, 150);
        	DrawString("\pScore: ");
        	DrawString(s); /* Draw the players score on the display */
        	
        	FrameRect(&gPlayAgainBtn);
        	MoveTo(240, 210);
        	DrawString("\pAgain!");  /* Draw a Play Again button on the display */
        if (PtInRect(mousePos, &gPlayAgainBtn)) InvertRect(&gPlayAgainBtn); /* Invert the Play Again button if the mouse moves over it */
    }

    /* --- Particle Effects (Explosions) --- */
    fullR = gOffscreen->portRect; ClipRect(&fullR); /* Asks GWorld for it's size, then gets permission to draw across the entire screen */
    for (i = 0; i < MAX_PARTICLES; i++) {
        if (gParticles[i].active) {  /* Check if particles has been activated */
            SetRect(&r, FIXED_TO_INT(gParticles[i].x), FIXED_TO_INT(gParticles[i].y), FIXED_TO_INT(gParticles[i].x) + 2, FIXED_TO_INT(gParticles[i].y) + 2); /* 2x2 squared of explosion pixels */
            PaintRect(&r); /* Fills in each of the 2x2 particle pixel rectangles */
        }
    }

    if (gFlashRequest) {
    	InvertRect(&gOffscreen->portRect); /* If the game calls for the screen to be momentarily inverted, this is it. */
    	gFlashRequest = false; /* After the flash inversion, set it back to false so it stops being inverted */
    }

    SetGWorld(oldPort, oldDevice); /* Cleanup, done with the off screen buffer, go take care of the actual display */
    UnlockPixels(hPixMap); /* Release the memory used for the gWorld off screen data so the system can alter that memory again */
}



void main(void) {
 	/* Setup the window */
    Rect wr, destR;
    Point m;
    Boolean d = false, q = false;
    EventRecord e;
    char key;
    /* Some ToolBox init stuff below */
    InitGraf(&qd.thePort); /* Init the memory manager */
    InitFonts(); /* Init the font manager */
    InitWindows(); /* Init windows manager */
    InitCursor(); /* Setup the cursor... no damn it, not that kind of cursor.. :D */
    SetRect(&wr, 10, 50, 500, 330); /* Define the rectangular window */
    gWindow = NewWindow(NULL, &wr, "\p", true, plainDBox, (WindowPtr)-1L, false, 0); /* Good plain ol' window, no fancy border or title bar */
    SetPort(gWindow); /* Set the window we'll be working in */
    NewGWorld(&gOffscreen, 1, &gWindow->portRect, NULL, NULL, 0); /* Off screen setup. 1 = bit depth (B&W), &gWindow->portRect says 'be the same size as the window', NULL, NULL, 0 just means default colour table and no special flags */ 
    InitSoundManager(); /* Init the Sound Manager, part of the system software (NOT part of Toolbox if you were wondering) */
    ShowSplashScreen(128); /* The PICT image I used all of my crayons to draw is stored in the resource fork at ID 128 */
    LoadHighScore();
    InitializeSpace();
    
    
    
        /* MAD Library Initialization */
    {
        MADDriverSettings init;
        OSErr err;

        err = MADInitLibrary("", false);
        if (err) DebugStr("\pMADInitLibrary Err");

        MADGetBestDriver(&init);

        err = MADCreateDriver(&init);
        if (err) DebugStr("\pMADCreateDriver Err");
    }

    /* Load and Start Music */
    if (MADLoadMusicRsrc('MADH', 3214) != noErr) DebugStr("\pMADLoadMusicRsrc Err"); /* The MOD music is stored INSIDE the resource fork in a resource called MADH, with ID 3214 */
    if (MADStartDriver() != noErr) DebugStr("\pMADStartDriver Err");
	    MADPlayMusic(); /* Play that funky music! */
	    
    while (!q) {  /* White !q (not q) because being q would quit! */
    	while (TickCount() < gNextFrameTick) SystemTask(); 
        gNextFrameTick = TickCount() + 2;                      /* Cap the game to 30fps so we don't take over the CPU completely */
        if (WaitNextEvent(everyEvent, &e, 0, NULL)) {
            if (e.what == keyDown) {                           /* If the event records a key down... */
                key = (char)(e.message & charCodeMask);        /* Decode the keyboard charCodeMask value and write the ascii value in 'key' */
                if (key == 27) {                               /* If ESC is pressed, quit */
                	if (gGameState == STATE_START) q = true;   /* q becomes true */
                	else { gGameState = STATE_START;
                		InitCursor();                          /* Show the mouse cursor again */
                		InitializeSpace();                     /* Go checkout void InitializeSpace(void) */
                	}
                }
                if (key == 32 && (gGameState == STATE_PLAYING || gGameState == STATE_BOSS)) UsePlasmaBomb(); /* Use a plasma bomb if SPACE BAR (32) is pressed and conditions are met */
                if ((key == 'b' || key == 'B') && gGameState == STATE_PLAYING) { /* Cheat key to cycle through the bosses and display them NOW */
                	gGameState = STATE_BOSS;
                	gBoss.active = true;
                	gBoss.x = INT_TO_FIXED(WIN_WIDTH); /* Enters from off screen on the right of the monitor */
                	gBoss.y = INT_TO_FIXED(100); /* Enters 100 pixels from the top */
                	gBoss.hp = 12; /* Takes 12 shots... this value could be randomized between two limits for more challenge */
                	gBossFireTimer = 0;
                }
            }
        }
        GetMouse(&m);
        if (gGameState == STATE_PLAYING || gGameState == STATE_BOSS) {
            if (m.v > (PLAY_AREA_BOTTOM - 8)) m.v = PLAY_AREA_BOTTOM - 8; /* Prevent the players ship from moving into the bottom Scroller area */
            if (m.v < (PLAY_AREA_TOP + 8)) m.v = PLAY_AREA_TOP + 8;       /* Prevent the players ship from moving into the top HUD area */
        }
        if (Button()) { 
            if (!d) { 
                if (gGameState == STATE_START) { 
                    if (PtInRect(m, &gStartBtn)) { gGameState = STATE_PLAYING; HideCursor(); } /* Hide the mouse cursor so it's not distracting from the ship sprite */
                    else if (PtInRect(m, &gAboutBtn)) gGameState = STATE_ABOUT;
                    else if (PtInRect(m, &gQuitBtn)) q = true;  /* Sad times when Q becomes true, back to reality... */
                    else if (PtInRect(m, &gMuteRect)) gSoundEnabled = !gSoundEnabled; /* Mute / unmute the SFX */
					else if (PtInRect(m, &gMusicRect)) gMusicEnabled = !gMusicEnabled; /* Mute / unmute the music */
					    if (gMusicEnabled) {
					        MADPlayMusic(); /* Pump up the jam and get that tuna playing! */
					    } else {
								MADStopMusic();   /* Stop playing the music */
								MADStopDriver();  /* Sometimes when music stops the last note becomes stuck 'on' indefinitely. */
								MADStartDriver(); /* Just like in IT, turning it off and on (the driver) fixes it... :) */
					}
                }
                else if (gGameState == STATE_ABOUT) gGameState = STATE_START; /* Return from ABOUT to the MAIN menu on click */
                else if (gGameState == STATE_PLAYING || gGameState == STATE_BOSS) FireLaser(m); /* Don't fire a laser on the menu... only in the proper STATE */
                else if (gGameState == STATE_GAMEOVER && PtInRect(m, &gPlayAgainBtn)) {     /* Game over, display the Again button */
                	InitializeSpace(); /* Initilize again, wipe score, reset asteroids, give 100% health, etc.. */
                	gGameState = STATE_PLAYING; /* Flips the login back into the game playing mode */
                	HideCursor(); } /* Hide the mouse cursor */
                	d = true;  /* Debounce the clicker button. sets d on first click and stays d until it isn't */
            	} 
        } else d = false;
        
        UpdateSpace(m); 
        DrawToBuffer(m); 
        destR = gWindow->portRect;
        if (gShakeTimer > 0) { OffsetRect(&destR, (abs(Random()) % 5) - 2, (abs(Random()) % 5) - 2); gShakeTimer--; }
        CopyBits((BitMap*)*GetGWorldPixMap(gOffscreen), &gWindow->portBits, &gWindow->portRect, &destR, srcCopy, NULL);
    }
    
    /* Cleanup all the fun we've been having when the player quits the game, shut down the sound manager and hand the memory back to the system */ 
    MADStopMusic();
    MADStopDriver();
    MADDisposeMusic();
    MADDisposeDriver();
    MADDisposeLibrary();
    CleanUpSound();
    DisposeGWorld(gOffscreen);
    DisposeWindow(gWindow);
}